/*

######################################################################
######################################################################
##                                                                  ##
##                                                                  ##
##                          netsubs                                 ##
##                                                                  ##
##                neural network subroutines                        ##
##                                                                  ##
##                           by                                     ##
##                                                                  ##
##                    Coryn Bailer-Jones                            ##
##                                                                  ##
##                         22/05/98                                 ##
##                                                                  ##
##             email: calj@mpia-hd.mpg.de                           ##
##               www: http://wol.ra.phy.cam.ac.uk/calj/             ##
##                                                                  ##
##                                                                  ##
##        This file is copyright 1998 by C.A.L. Bailer-Jones        ##
##                                                                  ##
##                                                                  ##
######################################################################
######################################################################


FILE:		netsubs.h
DESCRIPTION:    ANSI C network subroutines header file
AUTHOR:		Coryn Bailer-Jones
LAST MOD DATE:	08/12/98


######################################################################
######################################################################
##                                                                  ##
##                           netsubs.h                              ##
##                                                                  ##
######################################################################
######################################################################

*/

/* "function" definitions */

#define idelta(a,b) ( a==b ? 1   : 0   )
#define fdelta(a,b) ( a==b ? 1.0 : 0.0 )

/* type definitions */

typedef struct {
  double val;
  int   def;
} targets;

/* function prototypes */

void neterr(const char *);
void netwarn(const char *);

int   *Ivector(int);

double *Dvector(int);
double **Dpvector(int);
double **Dmatrix(int, int);
double ***Dmatrix3(int, int, int);
double ***Dpmatrix3_3(int);
long double *lDvector(int);

targets ***tpmatrix3_3(int);
targets **tmatrix(int, int);

char  *Cvector(int);

void free_Ivector(int *, int);

void free_Dvector(double *, int);
void free_Dpvector(double **, int);
void free_Dmatrix(double **, int, int);
void free_Dmatrix3(double ***, int, int, int);
void free_Dpmatrix3_3(double ***, int);
void free_lDvector(long double *, int);

void free_tmatrix(targets **, int, int);
void free_tpmatrix3_3(targets ***, int);

void free_Cvector(char *, int);

void vectmat(double **, double *, int, int, double *);

double Tf(double, double);
double dTf(double, double);
double Tg(double);
double dTg(double);

double errfn(double, double);

void updprev(int, double *, double *);

