/*

######################################################################
######################################################################
##                                                                  ##
##                                                                  ##
##                          dynet                                   ##
##                                                                  ##
##                a recurrent neural network                        ##
##              for modelling dynamical systems                     ##
##                                                                  ##
##                           by                                     ##
##                                                                  ##
##                    Coryn Bailer-Jones                            ##
##                                                                  ##
##                         22/05/98                                 ##
##                                                                  ##
##             email: calj@mpia-hd.mpg.de                           ##
##               www: http://www.mpia-hd.mpg.de/stars/calj          ##
##                                                                  ##
##                                                                  ##
##        see the README file for disclaimer and warranty           ##
##        see the dynet_manual file for operational details         ##
##                                                                  ##
##        This file is copyright 1998 by C.A.L. Bailer-Jones        ##
##                                                                  ##
##                                                                  ##
######################################################################
######################################################################


FILE:		dynet.h
DESCRIPTION:    ANSI C dynet header file
AUTHOR:		Coryn Bailer-Jones
LAST MOD DATE:	02.03.99


######################################################################
######################################################################
##                                                                  ##
##                           dynet.h                                ##
##                                                                  ##
######################################################################
######################################################################

*/

#include "ansi/macopt.h"
#include "netsubs.h"

#define VERSION     1.22
#define LASTMODDATE "02.03.99"

/* typedefs */

typedef struct {
  /* contains arguments for dynet gradient evaluation function */
  int Vsize;
  int Xsize;
  int Hsize;
  int Ysize;
  double **tsteps;
  int *ntsteps;
  double *alpha;
  double *beta;
  double ***x;
  targets ***tar; 
  double Hlam;
  int Npats;
  int *flag;
  FILE *errf;     /* file handle for error file */
  int wtvec_size;
  double *gtyp;   /* pointer to macopt rms gradient */
  int *its;       /* pointer to current macopt iteration number */
  int previts;    /* previous macopt iteration number */
  double lerr;    /* the likelihood contribution to the error */
  double werr;    /* the weight decay contribution to the error */
} dymacint_args;


/* defaults - note that VINITDEF and dVINITDEF are not changed by
   any scaling in dynet */

#define HBIAS         1.0 /* hidden layer bias node value */
#define XBIAS         1.0 /* input  layer bias node value */
#define VINITDEF      0.0 /* default initialisation value of v_prev
			     used if v at t(0) not specified in .tpin file */
#define dVINITDEF     0.0 /* default initialisation value dvXH, dvVH, dvHY
			     set by dysyswtinit() */

#define Nalpha         4   /* number of alpha parameters */
#define alpha_VH_DEF  0.04 /* default settings of the weight decay terms */
#define alpha_XH_DEF  0.04
#define alpha_bH_DEF  0.04
#define alpha_HY_DEF  0.00
#define BETADEF       6.0

#define WTRNGDEF       0.1 /* default range of intial random weights */
#define MACCHECKTOLDEF 0.000001 /* default macchecktol value */
#define RANSEEDDEF     731

#define INFILESUFFIX1 "tpin1"
#define INFILESUFFIX2 "tpin2"
#define OTFILESUFFIX  "tpot"
#define ERFILESUFFIX  "tper"
#define DEFWTNAME     "dynet.wt"
#define BETASTEM      "TRN:beta"

/* DEFWTNAME is output weight file name if none is specified in
   specfile */

/* maximum array sizes */

#define Nflags        100   /* number of flags */
#define MAXTPFILES    501   /* number of temporal process files */
#define WORDSIZE      500   /* various strings e.g. from specfile */
#define MESSAGESIZE   1000  /* messages */
#define FNAMESIZE     200   /* any file name */

/* others */

#define NODEWARNSIZE  100  /* will warn if number of nodes in any
			      network layer exceeds this value */
#define WTRNGWARNSIZE   5  /* will warn if initial weight range
			      exceeds this value */

/* prototypes in dynet */

void specread(char *, int *, int *, int *, int *, int *, int *, 
	      int *, double *, int *, char **, int *, char **,
	      char *, char *, long *, double *, int *, double *,
	      double *, char *, char *);

void dynettrain(int *, int, int, int, int, int, int,
		double **, double **, double **,
		double **, double **, double *, char *[], int, double,
		char *, char *, char *, long, double, int, double,
		double, char *);

void dynetapply(int *, int, int, int, int, int, int,
		double **, double **, double **, double **, double **,
		double *, char *[], char *, char *, char *, long,
		double, char *);

void dynetinit(int, int, int, int, int, int, double **, double **, double **,
	       double **, double **, double *, int *, char *, char *, long,
	       double **, double *, double *, double);

void dataread(int, int, int, char *[], int, double **, int *, double ***,
	      targets ***tar, int *);

void scalecalc(int, int, int, int *, double ***, targets ***, 
	       double **, double **, double *, int *);

void datascale(int, int, int, int *, double ***, targets ***,
	       double **, double **, int *);

void unscale(int, double *, double **, int *);

void dynetloopinit(int, double *, targets *);

void dynetloop(int, int, int, int,
	       double *, double *, double *, double *, double *, double,
	       double **, double **, double **, double);

void ederiv(int, int, int, int,
	    double *, double *, double *, double *, double *,
	    double **, double **, double **, double **, double **, double **,
	    targets *, double *, double *, double, double, int *);

void dysyswtinit(int, int, int, int, double ***, double ***, double ***);

void cumederivs(int, int, int, int,
		double **, double **, double **,
		double **, double **, double **);

void updatewt(double, int, int, int, int,
	      double **, double **, double **,
	      double **, double **, double **, int *);

void graddescent(int, int, int, int,
		 double **, double **, double **, double ***x,
		 targets ***, double **, int *, int, double *,
		 double *, double, int *, int, double);

void callmacopt(int, int, int, int,
		double **, double **, double **, double ***,
		targets ***, double **, int *, int, double *,
		double *, double, int *, char *, double, int, double);

void dymacint(double *, double *, void *);

double dymacfn(double *, void *);

void writeweights(int, int, int, int, int, double **, double **, double **,
		  double **, double **, double, char *, int *);

void evtpnewname(char *, char *, int *);

double wderr(int, int, int, int, double **, double **, double **, double *);


/* external prototypes in their own files */

float ran1(long *); 
