##### Plot the 11 bdvar light curve files in a 6x2 panel for the ctsmod paper

plot.data <- function(obsdata, lcurve) {
  xrange <- range(c(obsdata[,1]+obsdata[,2], obsdata[,1]-obsdata[,2]))
  ymin <- min(obsdata[,3]-obsdata[,4])
  yrange <- c(ymin, max(obsdata[,3]+obsdata[,4])) # +Delta_m is decrease in brightness!
  plot(obsdata[,1], obsdata[,3], xlim=xrange, ylim=yrange, pch=18, xlab="", ylab="")
  plotCI(obsdata[,1], obsdata[,3], uiw=obsdata[,4], err="y", type="n", gap=0, sfrac=0.01, add=TRUE)
  abline(h=0, lw=1, lty=2)
  title(main=lcurve, line=0.3, cex.main=1.0)
}

library(gplots)
pdf("bdvar_lcurves.pdf", width=7, height=7)
par(mfrow=c(6,2), mgp=c(2.0, 0.6, 0), mar=c(1.8, 1.8, 1.2, 0.5), oma=c(3.0, 3.0, 0.5, 0.5))
lcurveNames <-  c("2m0345", "2m0913", "2m1145",  "2m1145bb", "2m1146", "2m1334", "calar3", "sdss0539", "sori31", "sori33", "sori45")
lcurveLabels <- c("2m0345", "2m0913", "2m1145a", "2m1145b",  "2m1146", "2m1334", "calar3", "sdss0539", "sori31", "sori33", "sori45")
for(i in 1:length(lcurveNames)) {
  obsdataFname <- paste(lcurveNames[i], ".lcurve", sep="")
  obsdata <- as.matrix(read.table(obsdataFname, header=TRUE))
  if(ncol(obsdata)!=4) {stop("Data file ", obsdataFname, " does not have four columns")}
  plot.data(obsdata, lcurveLabels[i])
}
mtext("time / hrs",   side=1, line=1.0, outer=TRUE, cex=1.0)
mtext("signal / mag", side=2, line=1.0, outer=TRUE, cex=1.0)
dev.off()
