# C.A.L. Bailer-Jones
# Astrostats 2013
# This file: plot_OUprocess.R
# R code to produce plots related to the OU process

source("OUprocess.R")

# Generate and plot multiple time series from OU processes with different parameters
eventTimes <- seq(from=0, to=100, by=0.1)
yrange <- c(-15, +12)
limits <- NULL
set.seed(120)
pdf("ouprocTS.pdf", width=8, height=6)
par(mfcol=c(3,4), mar=c(0.25,0.25,0.25,0.25), oma=c(3,3,0.5,0.5), mgp=c(1.8,0.6,0), cex=1.0)
for(relax in c(1,10,100,1000)) {
  ouproc <- list(diffcon=1, relax=relax, zstartmean=0, zstartsd=0)
  for(i in 1:3) {
    xaxt <- ifelse(i==3, "s", "n")
    yaxt <- ifelse(relax==1, "s", "n")
    obsdata <- gen.OUprocess(ouproc=ouproc, eventTimes=eventTimes)$obsdata
    plot(obsdata[,1], obsdata[,3], ylim=yrange, pch=".", xaxt=xaxt, yaxt=yaxt, xlab="", ylab="")
    limits <- c(limits, range(obsdata[,3])) # to identify common yrange. Set, then re-run
  }
}
mtext("time", side=1, line=1.5, outer=TRUE, cex=1.0)
mtext("signal", side=2, line=1.5, outer=TRUE, cex=1.0)
cat("Full range = ", range(limits), "\n")
dev.off()

# Plot power spectrum for an OU process
tau <- 1
diffcon <- 1
pdf("ouproc_ps.pdf", width=8, height=4)
par(mfrow=c(1,2), mgp=c(2.0,0.6,0), mar=c(3.5,3.5,1.0,1.0), oma=c(0,0,0,0), cex=1.1)
w <- seq(from=0, to=5, length.out=5e3)
S <- (1/pi) * c*tau^2/(1 + (w*tau)^2)
plot(w, S, type="l", ylim=c(0,1.05*max(S)), xaxs="i", yaxs="i", xlab="frequency, w / radians", ylab="power, S(w)")
w <- seq(from=0, to=50, length.out=5e3)
S <- (1/pi) * c*tau^2/(1 + (w*tau)^2)
plot(log(w), log(S),type="l", xlab="log(w)", ylab="log(S)")
dev.off() 
