# C.A.L. Bailer-Jones
# Astrostats 2013
# This file: Rcheck.R
# Test of call to R using from python.
# It should print a 2x10 matrix of data to the screen and produce the a PDF file
# "linearmodel_data.pdf", showing some data points and a line through them.
# Then comment out - put a "#" in front of - the two lines "pdf(...)" and "dev.off()"
# and run again. This time the plot should appear on the screen in an X11 window.
# Provided one of these printing methods works you'll be okay for the course.

library(gplots) # for plotCI()

set.seed(50)
Ndat <- 10
x <- sort(runif(Ndat, 0, 10))
sigTrue <- 1
modMat <- c(0,1) # 1 x P vector: coefficients, a_p, of polynomial sum_{p=0} a_p*x^p
y <- cbind(1,x) %*% as.matrix(modMat) + rnorm(Ndat, 0, sigTrue)
# Dimensions in matrix multiplication: [Ndat x 1] = [Ndat x P] %*% [P x 1] + [Ndat]
# cbind does the logical thing combining a scalar and vector; then vector addition
y <- drop(y) # converts into a vector
pdf("linearmodel_data.pdf", width=5, height=4)
par(mfrow=c(1,1), mar=c(3.5,3.0,0.5,0.5), oma=c(0.5,0.5,0.5,0.5), mgp=c(2.2,0.8,0), cex=1.0)
plotCI(x, y, xlim=c(0,10), uiw=sigTrue, gap=0)
abline(a=modMat[1], b=modMat[2], col="red") # true model
dev.off()
# True parameters, transformed to be conformable with model to be used below
thetaTrue <- c(modMat[1], atan(modMat[2]), log10(sigTrue))
obsdata <- data.frame(cbind(x,y)) # only this is used in the analysis 
print(obsdata)
rm(x,y)
