# C.A.L. Bailer-Jones
# Astrostats 2013
# This file: MLR.R
# R code to analyse Mass-Luminosity relation data using

library(gplots) # for plotCI()

obsdata <- read.table("../data/MLR.dat", header=FALSE)[,c(1,2,9,10)]
pdf("MLR.pdf", width=5, height=4)
par(mfrow=c(1,1), mar=c(3.5,3.0,0.5,0.5), oma=c(0.5,0.5,0.5,0.5), mgp=c(2.2,0.8,0), cex=1.0)
plotCI(obsdata[,1], obsdata[,3], uiw=obsdata[,4], xlim=c(0,1.2), ylim=rev(range(obsdata[,3])), err="y",
       xlab="mass / M_sol", ylab="M_K / mag", pch=18, type="n", xaxs="i", gap=0, sfrac=0.01)
plotCI(obsdata[,1], obsdata[,3], uiw=obsdata[,2], err="x", type="n", gap=0, sfrac=0.01, add=TRUE)
dev.off()

# method outlined in lecture 2 can deal with uncertainties on both axes
# for now swap x and y and just take into account uncertainties on the masses
obsdata <- read.table("../data/MLR.dat", header=FALSE)[,c(9,10,1,2)]
plotCI(obsdata[,1], obsdata[,3], uiw=obsdata[,4], xlim=rev(range(obsdata[,1])), err="y",
        xlab="M_K / mag", ylab="mass / M_sol", pch=18, type="n", gap=0, sfrac=0.01)

# now use code in exp_linearmodel, exp_quadraticmodel and model_comparison_1.R to fit
# linear and quadratic models and to calculate evidence and/or K-fold CV likelihood.

